/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.math.Math;
import net.diebuddies.mixins.guiphysics.MixinAbstractSliderButtonAccessor;
import net.diebuddies.mixins.guiphysics.MixinAbstractWidgetAccessor;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.diebuddies.physics.settings.ux.TextAlignment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_357;
import net.minecraft.class_5253;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class SliderRenderer
extends Animator {
    private TextAlignment alignment;
    private boolean renderTooltips = true;
    private class_124 chatFormatting;

    public SliderRenderer(TextAlignment alignment, class_124 chatFormatting) {
        this.chatFormatting = chatFormatting;
        this.alignment = alignment;
    }

    public SliderRenderer(TextAlignment alignment) {
        this(alignment, null);
    }

    public SliderRenderer() {
        this(TextAlignment.CENTER);
    }

    @Override
    public boolean render(Animatable animatable, class_332 guiGraphics, int mouseX, int mouseY, float renderPercent, float delta) {
        boolean hovered = animatable.isInside(mouseX, mouseY);
        if (animatable instanceof MixinAbstractWidgetAccessor) {
            MixinAbstractWidgetAccessor accessor = (MixinAbstractWidgetAccessor)((Object)animatable);
            boolean wasHovered = accessor.getIsHovered();
            accessor.setIsHovered(hovered);
            if (!wasHovered && hovered) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15002, (float)(Math.random() * 0.2f + 0.9f)));
            }
        }
        class_357 slider = (class_357)animatable;
        MixinAbstractSliderButtonAccessor sliderAccessor = (MixinAbstractSliderButtonAccessor)((Object)animatable);
        Matrix4f pose = guiGraphics.method_51448().method_23760().method_23761();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        int color = BaseColors.BACKGROUND_COLOR;
        float x = animatable.getAnimX();
        float y = animatable.getAnimY();
        float width = animatable.getAnimWidth();
        float height = animatable.getAnimHeight();
        float depth = animatable.getAnimDepth() + 1.0f;
        SliderRenderer.drawRect(bufferBuilder, pose, x, y, width, height, depth, color);
        double value = sliderAccessor.getValue();
        int barSize = 8;
        float sliderOffset = (float)value * (width - (float)barSize);
        SliderRenderer.drawRect(bufferBuilder, pose, x + sliderOffset, y, barSize, height, depth + 1.0f, class_5253.class_5254.method_27764((int)100, (int)167, (int)167, (int)167));
        SliderRenderer.drawLine(bufferBuilder, pose, x + sliderOffset, y + 1.0f, x + sliderOffset + (float)barSize, y + 1.0f, depth + 2.0f, class_5253.class_5254.method_27764((int)255, (int)40, (int)40, (int)40));
        SliderRenderer.drawLine(bufferBuilder, pose, x + sliderOffset + 1.0f, y, x + sliderOffset + 1.0f, y + height - 1.0f, depth + 2.0f, class_5253.class_5254.method_27764((int)255, (int)40, (int)40, (int)40));
        color = BaseColors.BAR_COLOR;
        if (slider.method_25367()) {
            color = BaseColors.HIGHLIGHT_COLOR;
        }
        if (!slider.field_22763) {
            color = BaseColors.DISABLED_COLOR;
        }
        SliderRenderer.drawLine(bufferBuilder, pose, x + sliderOffset, y, x + sliderOffset + (float)barSize, y, depth + 3.0f, color);
        SliderRenderer.drawLine(bufferBuilder, pose, x + sliderOffset + (float)barSize, y, x + sliderOffset + (float)barSize, y + height - 1.0f, depth + 3.0f, color);
        SliderRenderer.drawLine(bufferBuilder, pose, x + sliderOffset, y + height - 1.0f, x + sliderOffset + (float)barSize, y + height - 1.0f, depth + 3.0f, color);
        SliderRenderer.drawLine(bufferBuilder, pose, x + sliderOffset, y, x + sliderOffset, y + height - 1.0f, depth + 3.0f, color);
        class_286.method_43433((class_9801)bufferBuilder.method_60794());
        RenderSystem.disableBlend();
        class_5481 formattedCharSequence = (this.chatFormatting == null ? slider.method_25369() : slider.method_25369().method_27661().method_27692(this.chatFormatting)).method_30937();
        class_327 font = class_310.method_1551().field_1772;
        float xText = x + 7.0f;
        if (this.alignment == TextAlignment.CENTER) {
            xText = x + width * 0.5f - (float)font.method_30880(formattedCharSequence) * 0.5f;
        } else if (this.alignment == TextAlignment.RIGHT) {
            xText = x + width - (float)font.method_30880(formattedCharSequence) - 7.0f;
        }
        SliderRenderer.drawText(guiGraphics, font, formattedCharSequence, Math.fastRound(xText), Math.fastRound(y + (height - 8.0f) / 2.0f));
        if (this.renderTooltips && animatable instanceof MixinAbstractWidgetAccessor) {
            class_339 widget;
            MixinAbstractWidgetAccessor invoker = (MixinAbstractWidgetAccessor)((Object)animatable);
            if (animatable instanceof class_339 && (widget = (class_339)animatable).method_25367() && widget.method_51254() != null) {
                ((MixinAbstractWidgetAccessor)widget).getTooltipHolder().method_56142(widget.method_49606(), widget.method_25370(), widget.method_48202());
            }
        }
        return true;
    }

    public void setRenderTooltips(boolean renderTooltips) {
        this.renderTooltips = renderTooltips;
    }

    public boolean isRenderingTooltips() {
        return this.renderTooltips;
    }
}

